package gov.va.genisis2.configuration;

import gov.va.genisis2.vo.CopyTableDomains;
import gov.va.genisis2.vo.CopyTableSource;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages = { "gov.va.genisis2.*" })
public class GenisisPropertiesUtil {

	
	@Value("${tablecopy.db.copy_script_cmd_filepath}")
	private String cmdFilePath;

	private String tableName;

	private String sourceSchemaName;

	private String destinationSchemaName;
	
	@Value("${activiti.mailSender}")
	private String activitiMailSender;
	

	// Table Copy new Attributes
	@Value("${tablecopy.db.source.server.name}")
	private String tcSourceDataBaseServerName;

	@Value("${tablecopy.db.source.server.database.name}")
	private String tcSourceDataBaseName;

	@Value("${tablecopy.db.destination.server.name}")
	private String tcDestinationDataBaseServerName;

	@Value("${tablecopy.db.destination.user.name}")
	private String tcDestinationDataBaseUserName;

	@Value("${tablecopy.db.destination.user.password}")
	private String tcDestinationDataBaseUserPassvalue;

	@Value("${tablecopy.db.destination.server.database.name}")
	private String tcDestinationServerDataBaseName;

	@Value("${tablecopy.db.management.database.server.name}")
	private String tcManagementDataBaseServerName;

	@Value("${tablecopy.db.management.username}")
	private String tcManagementDataBaseUserName;

	@Value("${tablecopy.db.management.password}")
	private String tcManagementDataBaseUserPassvalue;

	@Value("${tablecopy.db.management.schema}")
	private String tcManagementDataBaseSchema;

	@Value("${tablecopy.db.source.user.name}")
	private String tcSourceDataBaseUserName;

	@Value("${tablecopy.db.management.database.name}")
	private String tcManagementDataBaseName;

	@Value("${tablecopy.db.temporary.database.name}")
	private String tcTemporaryDataBaseName;
	
	@Value("${genisis2.pom.props.path}")
	private String genisisPomPropsPath;


	/**
	 * @return genisisPomPropsPath
	 */
	public String getGenisisPomPropsPath() {
		return genisisPomPropsPath;
	}
	
	/**
	 * sets genisisPomPropsPath
	 * 
	 * @param genisisPomPropsPath genisisPomPropsPath 
	 */
	public void setGenisisPomPropsPath(String genisisPomPropsPath) {
		this.genisisPomPropsPath = genisisPomPropsPath;
	}
	
	@Bean
	protected CopyTableDomains getCopyTableDomainsDetails() {
		return new CopyTableDomains(getTcSourceDataBaseName(), getTcDestinationServerDataBaseName(), getTcSourceDataBaseServerName(),
				getTcDestinationDataBaseServerName(), getTcSourceDataBaseUserName(), getTcDestinationDataBaseUserName());
	}

	@Bean
	protected CopyTableSource getCopyTableSource() {
		return new CopyTableSource(getTableName(), getTcSourceDataBaseServerName(), getTcSourceDataBaseName(), getSourceSchemaName(),
				getTcDestinationDataBaseServerName(), getTcDestinationDataBaseUserName(), getTcDestinationDataBaseUserPassvalue(),
				getTcDestinationServerDataBaseName(), getDestinationSchemaName(), getTcManagementDataBaseServerName(),
				getTcManagementDataBaseUserName(), getTcManagementDataBaseUserPassvalue(), getTcManagementDataBaseSchema(), getCmdFilePath(),
				getTcManagementDataBaseName(), getTcTemporaryDataBaseName());
	}
	
	
	@Bean
	public String getActivitiMailSender() {
		return new String(activitiMailSender);
	}
	
	/**
	 * @return the cmdFilePath
	 */
	public String getCmdFilePath() {
		return cmdFilePath;
	}

	/**
	 * @return the tableName
	 */
	public String getTableName() {
		return tableName;
	}

	/**
	 * @return the sourceSchemaName
	 */
	public String getSourceSchemaName() {
		return sourceSchemaName;
	}

	/**
	 * @return the destinationSchemaName
	 */
	public String getDestinationSchemaName() {
		return destinationSchemaName;
	}

	/**
	 * @return the tcSourceDataBaseServerName
	 */
	public String getTcSourceDataBaseServerName() {
		return tcSourceDataBaseServerName;
	}

	/**
	 * @return the tcSourceDataBaseName
	 */
	public String getTcSourceDataBaseName() {
		return tcSourceDataBaseName;
	}

	/**
	 * @return the tcDestinationDataBaseServerName
	 */
	public String getTcDestinationDataBaseServerName() {
		return tcDestinationDataBaseServerName;
	}

	/**
	 * @return the tcDestinationDataBaseUserName
	 */
	public String getTcDestinationDataBaseUserName() {
		return tcDestinationDataBaseUserName;
	}

	/**
	 * @return the tcDestinationDataBaseUserPassvalue
	 */
	public String getTcDestinationDataBaseUserPassvalue() {
		return tcDestinationDataBaseUserPassvalue;
	}

	/**
	 * @return the tcDestinationServerDataBaseName
	 */
	public String getTcDestinationServerDataBaseName() {
		return tcDestinationServerDataBaseName;
	}

	/**
	 * @return the tcManagementDataBaseServerName
	 */
	public String getTcManagementDataBaseServerName() {
		return tcManagementDataBaseServerName;
	}

	/**
	 * @return the tcManagementDataBaseUserName
	 */
	public String getTcManagementDataBaseUserName() {
		return tcManagementDataBaseUserName;
	}

	/**
	 * @return the tcManagementDataBaseUserPassvalue
	 */
	public String getTcManagementDataBaseUserPassvalue() {
		return tcManagementDataBaseUserPassvalue;
	}

	/**
	 * @return the tcManagementDataBaseSchema
	 */
	public String getTcManagementDataBaseSchema() {
		return tcManagementDataBaseSchema;
	}

	/**
	 * @return the tcSourceDataBaseUserName
	 */
	public String getTcSourceDataBaseUserName() {
		return tcSourceDataBaseUserName;
	}

	/**
	 * @return the tcManagementDataBaseName
	 */
	public String getTcManagementDataBaseName() {
		return tcManagementDataBaseName;
	}

	/**
	 * @return the tcTemporaryDataBaseName
	 */
	public String getTcTemporaryDataBaseName() {
		return tcTemporaryDataBaseName;
	}

}
